MoneyMods = {};
MoneyMods.dir = g_currentModDirectory;

function MoneyMods:loadMap(name)
    self.cashSample = createSample("cashSample");
    loadSample(self.cashSample,Utils.getFilename("cash.wav",MoneyMods.dir), false);
    self.cashOverlay = createImageOverlay(Utils.getFilename("cash1.dds",MoneyMods.dir));
    self.cashOverlayTime = 0;
end;

function MoneyMods:keyEvent(unicode, sym, modifier, isDown)
  local money = -500000;
  if g_isDevelopmentVersion or g_currentMission.isMasterUser or g_currentMission:getIsServer() then
    if bitAND(modifier, Input.MOD_ALT) > 0 then
        self.cashOverlayTime = 300;
        playSample(self.cashSample, 1, 1, 0);
        if g_currentMission:getIsServer() then
          g_currentMission:addSharedMoney(money, "other")
        else
          g_client:getServerConnection():sendEvent(CheatMoneyEvent:new(money))
        end
    end;
  end
end;

function MoneyMods:update(dt)
  if self.cashOverlayTime > 0 then
    self.cashOverlayTime=self.cashOverlayTime-dt;
  end;
end;

function MoneyMods:draw()
  if self.cashOverlayTime > 0 then
    renderOverlay(self.cashOverlay,0,0,1,1);
  end;
end;

function MoneyMods:deleteMap()
end;

function MoneyMods:mouseEvent(posX, posY, isDown, isUp, button)
end;
addModEventListener(MoneyMods);
