MoneyMod = {};
MoneyMod.dir = g_currentModDirectory;

function MoneyMod:loadMap(name)
    self.cashSample = createSample("cashSample");
    loadSample(self.cashSample,Utils.getFilename("cash.wav",MoneyMod.dir), false);
    self.cashOverlay = createImageOverlay(Utils.getFilename("cash.dds",MoneyMod.dir));
    self.cashOverlayTime = 0;
end;

function MoneyMod:keyEvent(unicode, sym, modifier, isDown)
  local money = 500000;
  if g_isDevelopmentVersion or g_currentMission.isMasterUser or g_currentMission:getIsServer() then
    if bitAND(modifier, Input.MOD_CTRL) > 0 then
        self.cashOverlayTime = 300;
        playSample(self.cashSample, 1, 1, 0);
        if g_currentMission:getIsServer() then
          g_currentMission:addSharedMoney(money, "other")
        else
          g_client:getServerConnection():sendEvent(CheatMoneyEvent:new(money))
        end
    end;
  end
end;

function MoneyMod:update(dt)
  if self.cashOverlayTime > 0 then
    self.cashOverlayTime=self.cashOverlayTime-dt;
  end;
end;

function MoneyMod:draw()
  if self.cashOverlayTime > 0 then
    renderOverlay(self.cashOverlay,0,0,1,1);
  end;
end;

function MoneyMod:deleteMap()
end;

function MoneyMod:mouseEvent(posX, posY, isDown, isUp, button)
end;
addModEventListener(MoneyMod);
